#! /usr/local/bin/perl -w
#
# Converter from DIYGeiger-MK161 .TXT log format to .CSV file
#
# File: mk161log_to_csv.pl
#
# Copyright (C) 2013 Vitali Samurov
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#
use strict;
use warnings;

my(
    $fileToWrite,
    $verNumMajor,
    $verNumMinor,
    $debug,
    $lineCounterTotal,
    $lineCounterInfo,
    $processingLine,
    $cpm,
    @time_value,
    $hours,
    $mins,
    $secs,
    $day,
    $month,
    $year,
    );

################################## Version ######################################
$verNumMajor = 1;
$verNumMinor = 1;
#################################################################################

$debug = 0; # 0 = no debug dumps
$lineCounterTotal = 0;
$lineCounterInfo = 0;

print "***** Num of arguments: " . scalar @ARGV . "\n" if $debug;

if(!$ARGV[0])
{
    die "\nUsage: mk161log_to_csv.pl <Input_File.txt> <Output_File> [Description String]\n\n";
}

open (IN, $ARGV[0]) or die "Unable to open file $ARGV[0]!\n";

$fileToWrite = $ARGV[1] .".csv";
open (OUT, ">".$fileToWrite) or die "Unable to open file $fileToWrite!\n\n";
print "Processing: file '" . $ARGV[0] . "' to file '" . $fileToWrite . "' ...\n";

#Init variables

print OUT "Input File: $ARGV[0]\n";
print OUT "Output File: $fileToWrite\n";
if ((scalar @ARGV) > 2)
{
    print OUT "Description: $ARGV[2]\n";
}

print OUT "---------------\n#, CPM, Time, Date,\n";

while(<IN>)
{
    if(m/([0-9]+)\s+([0-9]+)\s+([0-9,]+)\s+([0-9]+)/)
    {
        print "***** # value: $1; CPM: $2; time: $3; date: $4\n" if $debug;
        $processingLine = $1;
        $cpm = $2;

        if ($cpm > 0)
        {
            #Convert time
            if (length($3) > 2)
            {
                @time_value = split(/,/, $3);
                $hours = $time_value[0];

                print "***** length(time_value[1]): " . length($time_value[1]) . "\n" if $debug;

                if (length($time_value[1]) == 4)
                {
                    $mins = substr($time_value[1], 0, 2);
                    $secs = substr($time_value[1], 2, 2);
                }
                elsif (length($time_value[1]) == 3)
                {
                    $mins = substr($time_value[1], 0, 2);
                    $secs = substr($time_value[1], 2, 1);
                }
                elsif (length($time_value[1]) == 2)
                {
                    $mins = substr($time_value[1], 0, 2);
                    $secs = "00";
                }
                else
                {
                    $mins = substr($time_value[1], 0, 1) . "0";
                    $secs = "00";
                }

                if (length($mins) == 1)
                {
                    $mins = $mins . "0";
                }

                if (length($secs) == 1)
                {
                    $secs = $secs . "0";
                }
            }
            else
            {
                if(length($3) > 1)
                {
                    $hours = $3;
                    $mins = "00";
                    $secs = "00";
                }
                else
                {
                    $hours = $3 . "0";
                    $mins = "00";
                    $secs = "00";
                }
            }

            #Convert date
            $day = substr($4, 0, 2);
            $month = substr($4, 2, 2);
            $year  = substr($4, 4, 4);

            print "***** time_value: @time_value; time: $hours:$mins:$secs\n" if $debug;
            print OUT "$processingLine, $cpm, $hours:$mins:$secs, $day.$month.$year,\n";
            $lineCounterInfo++;
        }
    }

    $lineCounterTotal++;
}

print "Done\nProcessed lines (total): " . $lineCounterTotal . " (informative): " .$lineCounterInfo . "\n";

close IN;
print OUT "---------------\nProcessed lines (total): " . $lineCounterTotal . " (informative): " .$lineCounterInfo . "\n";
print OUT "Generated by 'mk161log_to_csv.pl' ver.$verNumMajor.$verNumMinor\n";
print OUT "Perl version: " . $^V;
close OUT;

