#!/usr/bin/octave -qf
%
% Copyright (C) 2014 Vitali Samurov
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Octave; see the file COPYING.  If not, see
% <http://www.gnu.org/licenses/>.
%
% Author: Vitali Samurov <vitali dot s at elisanet dot fi>
% Created: 13.08.2014

close all;

%==================== SET section ===================
mkn2txt_app = 'mkn2txt-0.12.i386.win32.exe -n+ -i noname.mkn';
pmkcom_app = 'pmkcom-0.19.i386.win32.exe';
pmkcom_port = '1';    % COM-port for PMKCOM utility
boud = '19200';       % COM-port speed

disp('---------------- Diy161getLog, ver. 1.0 ----------------');
arg_list = argv ();
arg_size = size(arg_list);

if arg_size(1) == 4
    lable = arg_list{1};
    skip_ekvm = arg_list{2};
    from_rec = arg_list{3};
    to_rec = arg_list{4};

    if skip_ekvm == '1'
        disp('Downloading log from EKVM');

        pmkcom_arg = [pmkcom_app, ' --p ',pmkcom_port, ' --s ',boud, ' -rn ', from_rec, ' ',to_rec];

        [P_STATUS, P_OUTPUT] = system(pmkcom_arg);
        disp (['Pmkcom status: ', P_STATUS]);

        [M_STATUS, M_OUTPUT] = system(mkn2txt_app);
        disp (['Mkn2txt status: ', M_STATUS]);

        [status, msg, msgid] = mkdir(lable);
        if status != 1
            disp(['Error! ', msg]);
            return
        else
            full_filename = [lable, '\', lable, '.txt'];
            copyfile ('noname.txt', full_filename);
            delete 'noname.mkn';
            delete 'noname.htm';
            delete 'noname.txt';
        endif
    endif

    full_filename = [lable, '\', lable, '.txt'];
    disp(['Processing file: ', full_filename]);
    [dir, name, ext, ver] = fileparts (full_filename);
    data = dlmread(full_filename);
    cpm = (data(:,2))';
    cpm(cpm==0) = [];
    cpm_mean = mean(cpm);
    disp (['CPM mean: ', num2str(round(cpm_mean))]);

    cpm_median = median(cpm);
    disp (['CPM median: ', num2str(round(cpm_median))]);

    cpm_min = min(cpm);
    disp (['CPM min: ', num2str(cpm_min)]);

    cpm_max = max(cpm);
    disp (['CPM max: ', num2str(cpm_max)]);

    cpm_length = numel(cpm);
    if rem(cpm_length, 10) != 0
        cpm(end + (10 - rem(cpm_length, 10))) = 0;
        cpm_length = numel(cpm);
    endif

    cpm_10x_matrix = reshape(cpm, 10, cpm_length/10);
    cpm_10x_plot = zeros (4, cpm_length/10);

    for i=1:(cpm_length/10)
        cpm_temp = (cpm_10x_matrix(:,i))';
        cpm_temp_mean = mean(cpm_temp);
        cpm_temp_median = median(cpm_temp);
        cpm_temp_min = min(cpm_temp);
        cpm_temp_max = max(cpm_temp);
        cpm_10x_plot(1,i) = cpm_temp_mean;
        cpm_10x_plot(2,i) = cpm_temp_median;
        cpm_10x_plot(3,i) = cpm_temp_min;
        cpm_10x_plot(4,i) = cpm_temp_max;
    endfor

    fid = fopen(full_filename);
    txt_line = fgetl(fid);
    fclose(fid);
    [tok, rem] = strtok(txt_line);
    [tok, rem] = strtok(rem);
    [tok, rem] = strtok(rem);
    a = str2num(tok);
    start_time = [num2str(a(1)), ':', num2str(floor(a(2)/100))];
    [tok, rem] = strtok(rem);
    b = str2num(tok);
    day = floor(b/1000000);
    month = floor((b - day * 1000000)/10000);
    year = substr(tok, length(tok) - 3, 4);
    start_date = [num2str(day), '.', num2str(month), '.', year];

    h1=subplot (2, 1, 1);
    plot(cpm_10x_plot');
    legend ('Mean', 'Median', 'Min', 'Max');
    title(['Log file: ', name], 'interpreter', 'none');
    xlabel (['Time (x 150 sec), REC started at time ', start_time, ' date ', start_date]);
    ylabel ("Counts per minute (CPM)");
    grid on

    disp('Still processing ...')

    h2 = subplot (2, 1, 2);
    hist(cpm, 150);
    xlabel ("Counts per minute (CPM)");
    ylabel ("CPM Frequency");
    grid on
    disp('Press <ENTER> in console to close plot and exit')
    pause
else
    disp('Usage: octave diy161getLog [lable] [skip_ekvm] [from] [to]');
    disp('   where');
    disp('   - lable: log will be saved as \<lable>\<lable>.txt;');
    disp('   - skip_ekvm: 1 - download log from EKVM, 0 - process <lable> file only');
    disp('   - from: start_record of notebook to download;');
    disp('   - to: end_record of notebook to download');
endif

