******************************************************
*                                                    *
* File: GUI.H                                        *
*                                                    *
* Purpose: DEFINEs for use with InputForms           *
*                                                    *
******************************************************

******************************************************
* InputForm Field Types                              *
******************************************************
DEFINE FTYPE_TEXT	ONE
DEFINE FTYPE_ALGTEXT    THREE
DEFINE FTYPE_CHOOSE	TWELVE
DEFINE FTYPE_CHECK	THIRTYTWO

******************************************************
* InputForm Object Types                             *
******************************************************
DEFINE OBTYPE_NA	MINUSONE ( Ob Type Not Applicable )
DEFINE OBTYPE_ANY	MINUSONE
DEFINE OBTYPE_REAL	ZERO
DEFINE OBTYPE_CMP	ONE
DEFINE OBTYPE_STR	TWO
DEFINE OBTYPE_RARRAY	THREE
DEFINE OBTYPE_CARRAY	FOUR
DEFINE OBTYPE_LIST	FIVE
DEFINE OBTYPE_ID	SIX
DEFINE OBTYPE_USERPRGM	EIGHT
DEFINE OBTYPE_SYMB	NINE
DEFINE OBTYPE_HXS	TEN
DEFINE OBTYPE_UNIT	THIRTEEN

******************************************************
* InputForm Decompile Formats                        *
******************************************************
DEFINE FMT_NA		MINUSONE ( Format Not Applicable )
DEFINE FMT_NONE		ONE
DEFINE FMT_DFLT		TWO
DEFINE FMT_STD		FOUR
DEFINE FMT_1STCHAR	EIGHT
DEFINE FMT_PART1	SIXTEEN
DEFINE FMT_PART2	THIRTYTWO

DEFINE FMT_NONE&1STCH	NINE
DEFINE FMT_P1&NONE	SEVENTEEN
DEFINE FMT_P1&DFLT	EIGHTEEN
DEFINE FMT_P1&STD	TWENTY
DEFINE FMT_P2&NONE	THIRTYTHREE
DEFINE FMT_P2&DFLT	THIRTYFOUR
DEFINE FMT_P2&STD	THIRTYSIX

******************************************************
* Standard InputForm Label Rows                      *
******************************************************
DEFINE LROW1		TEN
DEFINE LROW2		NINETEEN
DEFINE LROW3		TWENTYEIGHT
DEFINE LROW4		THIRTYSEVEN
DEFINE LROW5		FORTYSIX

******************************************************
* Standard InputForm Field Rows                      *
******************************************************
DEFINE FROW1		EIGHT
DEFINE FROW2		SEVENTEEN
DEFINE FROW3		TWENTYSIX
DEFINE FROW4		THIRTYFIVE
DEFINE FROW5		FORTYFOUR

******************************************************
* Standard InputForm Colums for Labels and Fields    *
******************************************************
*                                                    *
* Note: COL1+C refers to the label position for a    *
*       check field whose check is specified in COL1.*
*                                                    *
******************************************************
DEFINE COL1		ONE
DEFINE COL1+C		EIGHT
DEFINE COL1.5		FOUR
DEFINE COL1.5+C		ELEVEN
DEFINE COL2		SEVEN
DEFINE COL2+C		FOURTEEN
DEFINE COL2.5		TEN
DEFINE COL3		THIRTEEN
DEFINE COL3.5		SIXTEEN
DEFINE COL4		NINETEEN
DEFINE COL4.5		TWENTYTWO
DEFINE COL4.5+C		TWENTYNINE
DEFINE COL5		TWENTYFIVE
DEFINE COL5+C		THIRTYTWO
DEFINE COL5.5		TWENTYEIGHT
DEFINE COL6		THIRTYONE
DEFINE COL6.5		THIRTYFOUR
DEFINE COL7		THIRTYSEVEN
DEFINE COL7.5		FORTY
DEFINE COL7.5+C		FORTYSEVEN
DEFINE COL8		FORTYTHREE
DEFINE COL8+C		FIFTY
DEFINE COL8.5		FORTYSIX
DEFINE COL9		FORTYNINE
DEFINE COL9+C		FIFTYSIX
DEFINE COL9.5		FIFTYTWO
DEFINE COL10		FIFTYFIVE
DEFINE COL10+C		SIXTYTWO
DEFINE COL10.5		FIFTYEIGHT
DEFINE COL11		SIXTYONE
DEFINE COL11.5		SIXTYFOUR
DEFINE COL11.5+C	71
DEFINE COL12		FOURTHREE ( decimal 67 )
DEFINE COL12+C		SEVENTYFOUR
DEFINE COL12.5		SEVENTY
DEFINE COL13		73
DEFINE COL13+C		EIGHTY
DEFINE COL13.5		76
DEFINE COL14		SEVENTYNINE
DEFINE COL14+C		FIVESIX ( decimal 86 )
DEFINE COL14.5		LISTCMP ( decimal 82 )
DEFINE COL15		2LIST ( decimal 85 )
DEFINE COL15+C		92
DEFINE COL15.5		88
DEFINE COL15.5+C	95
DEFINE COL16		BINT_91d
DEFINE COL16+C		NINETYEIGHT
DEFINE COL16.5		94
DEFINE COL16.5+C	SIXFIVE ( decimal 101 )
DEFINE COL17		IDREAL ( decimal 97 )
DEFINE COL17+C		104
DEFINE COL17.5		IDARRY ( decimal 100 )
DEFINE COL17.5+C	107
DEFINE COL18		103
DEFINE COL18+C		110
DEFINE COL18.5		106
DEFINE COL18.5+C	LAMREAL ( decimal 113 )
DEFINE COL19		109
DEFINE COL19+C		BINT_116d
DEFINE COL19.5		lamany ( decimal 112 )
DEFINE COL19.5+C	119
DEFINE COL20		BINT_115d
DEFINE COL20+C		BINT_122d
DEFINE COL20.5		118
DEFINE COL21		121
DEFINE COL21.5		124
DEFINE COL22		127

******************************************************
* Standard InputForm Field Widths and Height         *
******************************************************
DEFINE FHEIGHT		NINE ( field height )
DEFINE FWIDTH_C		SIX  ( check field width )
DEFINE FWIDTH1		SEVEN
DEFINE FWIDTH2		THIRTEEN
DEFINE FWIDTH3		NINETEEN
DEFINE FWIDTH4		TWENTYFIVE
DEFINE FWIDTH5		THIRTYONE
DEFINE FWIDTH6		THIRTYSEVEN
DEFINE FWIDTH7		FORTYTHREE
DEFINE FWIDTH8		FORTYNINE
DEFINE FWIDTH9		FIFTYFIVE
DEFINE FWIDTH10		SIXTYONE
DEFINE FWIDTH11		FOURTHREE ( decimal 67 )
DEFINE FWIDTH12		73
DEFINE FWIDTH13		SEVENTYNINE
DEFINE FWIDTH14		2LIST ( decimal 85 )
DEFINE FWIDTH15		BINT_91d
DEFINE FWIDTH16		IDREAL ( decimal 97 )
DEFINE FWIDTH17		103
DEFINE FWIDTH18		109
DEFINE FWIDTH19		BINT_115d
DEFINE FWIDTH20		121
DEFINE FWIDTH21		127

******************************************************
* Null/Placeholder Parameters                        *
******************************************************
DEFINE NOVAL		MINUSONE
DEFINE FVAL_NA		MINUSONE
DEFINE FVAL_NULL	MINUSONE
DEFINE OPTDATA_NULL	MINUSONE
